import { View, StyleSheet, FlatList } from "react-native";
import React from "react";
import SkeletonElement from "../../../../SkeletonElement";
import dpr from "../../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { OrderDetailsStyle } from "../../../../../../screens/Profile/OrderHistory/OrderDetails/OrderDetailsStyle";

const RenderItem = ({ item }) => (
    <View style={styles.container}>
        <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 260)} />
        <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 210)} />
        <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 260)} />

        <View style={styles.marginTop(30)}>
            <SkeletonElement wrapperStyle={styles.skeletonWrapper(30, 40)} />
        </View>
        <View
            style={[
                OrderDetailsStyle.deliveryCont,
                styles.marginTop(26)
            ]}
        >
            <View style={OrderDetailsStyle.deliverySubCont}>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
            </View>
            <View
                style={[
                    OrderDetailsStyle.deliverySubCont,
                    styles.elementContainerStyle2,
                ]}
            >
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
            </View>
        </View>
        <View
            style={[
                OrderDetailsStyle.deliveryCont,
                styles.marginTop(26),
            ]}
        >
            <View style={OrderDetailsStyle.deliverySubCont}>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
            </View>
            <View
                style={[
                    OrderDetailsStyle.deliverySubCont,
                    styles.elementContainerStyle4,
                ]}
            >
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
            </View>
        </View>
        <View style={styles.marginTop(30)}>
            <SkeletonElement wrapperStyle={styles.skeletonWrapper(12, 220)} />
            <View style={OrderDetailsStyle.shoppingTextCont}>
                <View style={OrderDetailsStyle.shoppingTextWidth}>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle} />
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                </View>
                <View style={OrderDetailsStyle.shoppingTextWidth}>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                    <View style={styles.marginTop(12)}>
                        <SkeletonElement wrapperStyle={styles.wrapperCommonStyle}/>
                    </View>
                </View>
            </View>
        </View>
    </View>
);

const OrderDetailsSkeleton = () => {
    return (
        <View>
            <FlatList
                data={[1]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default OrderDetailsSkeleton;

const styles = StyleSheet.create({
    container: {
        marginTop: dpr(20),
        flex: 1,
        alignItems: "center",
    },
    elementContainerStyle2: {
        borderLeftWidth: 1,
        borderColor: "#B1B1B1",
    },
    elementContainerStyle4: {
        borderLeftWidth: 1,
        borderColor: "#B1B1B1",
    },
    shipping: {
        marginTop: dpr(20),
        flex: 1,
        flexDirection: "row",
        justifyContent: "space-between",
    },
    marginTop: (value) => ({
        marginTop: dpr(value),
    }),
    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),
    wrapperCommonStyle: {
        height: dpr(12),
        width: dpr("wf") - dpr(280),
    },
});
